---
description: Crear nueva funcionalidad completa (Controller, Requests, Pages, rutas)
---

# Crear Módulo/Funcionalidad

Este workflow crea una funcionalidad completa con backend y frontend.

## Parámetros Requeridos

- `{Funcionalidad}`: Nombre de la funcionalidad (ej: Users, Products, Orders)
- `{Nombre}`: Nombre del recurso en singular (ej: User, Product, Order)

## Pasos

### 1. Crear Controller

// turbo

```bash
php artisan make:controller {Funcionalidad}/{Nombre}Controller --resource --no-interaction
```

### 2. Crear Form Requests para Store y Update

// turbo

```bash
php artisan make:request {Funcionalidad}/Store{Nombre}Request --no-interaction
```

// turbo

```bash
php artisan make:request {Funcionalidad}/Update{Nombre}Request --no-interaction
```

### 3. Crear Modelo (si no existe)

// turbo

```bash
php artisan make:model {Nombre} -mfs --no-interaction
```

Esto crea:

- Modelo
- Migración
- Factory
- Seeder

### 4. Agregar Rutas en `routes/web.php`

```php
use App\Http\Controllers\{Funcionalidad}\{Nombre}Controller;

Route::resource('{nombre-plural}', {Nombre}Controller::class)
    ->middleware(['auth', 'verified']);
```

### 5. Crear Páginas Inertia

Crear los siguientes archivos en `resources/js/pages/{funcionalidad}/`:

- `index.tsx` - Lista de recursos
- `show.tsx` - Detalle de recurso
- `create.tsx` - Formulario de creación
- `edit.tsx` - Formulario de edición

### 6. Generar Wayfinder

// turbo

```bash
php artisan wayfinder:generate
```

### 7. Crear Test Feature

// turbo

```bash
php artisan make:test {Funcionalidad}/{Nombre}Test --pest --no-interaction
```

### 8. Formatear Código

// turbo

```bash
vendor/bin/pint --dirty
```

## Estructura Resultante

```
app/
├── Http/
│   ├── Controllers/{Funcionalidad}/{Nombre}Controller.php
│   └── Requests/{Funcionalidad}/
│       ├── Store{Nombre}Request.php
│       └── Update{Nombre}Request.php
└── Models/{Nombre}.php

database/
├── factories/{Nombre}Factory.php
├── migrations/xxxx_create_{nombres}_table.php
└── seeders/{Nombre}Seeder.php

resources/js/pages/{funcionalidad}/
├── index.tsx
├── show.tsx
├── create.tsx
└── edit.tsx

tests/Feature/{Funcionalidad}/{Nombre}Test.php
```

## Verificación

// turbo

```bash
php artisan test --compact --filter={Nombre}Test
```
