---
description: Buscar documentación de Laravel, Inertia, Pest, etc. usando Laravel Boost
---

# Buscar Documentación con Laravel Boost

// turbo-all

Este workflow permite buscar documentación actualizada del ecosistema Laravel usando el MCP de Laravel Boost.

## Paquetes Disponibles para Búsqueda

| Paquete           | Versiones         |
| ----------------- | ----------------- |
| Laravel Framework | 10.x, 11.x, 12.x  |
| Inertia           | 1.x, 2.x          |
| Livewire          | 1.x, 2.x, 3.x     |
| Filament          | 2.x, 3.x, 4.x     |
| Pest              | 3.x, 4.x          |
| Tailwind CSS      | 3.x, 4.x          |
| Nova              | 4.x, 5.x          |
| Flux UI           | 2.x Free, 2.x Pro |

## Uso Básico

### Buscar con una consulta simple

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["tu consulta aquí"]}}}' | php artisan boost:mcp 2>/dev/null
```

### Buscar con múltiples consultas

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["useForm validation","form errors","validation rules"]}}}' | php artisan boost:mcp 2>/dev/null
```

### Limitar búsqueda a paquetes específicos

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["useForm"],"packages":["@inertiajs/react"]}}}' | php artisan boost:mcp 2>/dev/null
```

## Ejemplos de Consultas Útiles

### Inertia + React

```bash
# Forms y validación
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["useForm validation errors"]}}}' | php artisan boost:mcp 2>/dev/null

# Deferred props (Inertia v2)
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["deferred props lazy loading"]}}}' | php artisan boost:mcp 2>/dev/null

# WhenVisible component
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["WhenVisible infinite scroll"]}}}' | php artisan boost:mcp 2>/dev/null
```

### Laravel

```bash
# Eloquent relationships
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["eloquent relationships hasMany belongsTo"]}}}' | php artisan boost:mcp 2>/dev/null

# Form Requests
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["form request validation authorize"]}}}' | php artisan boost:mcp 2>/dev/null

# Middleware
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["middleware authentication"]}}}' | php artisan boost:mcp 2>/dev/null
```

### Pest Testing

```bash
# Browser testing
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["pest browser testing visit click"]}}}' | php artisan boost:mcp 2>/dev/null

# Datasets
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["pest datasets validation"]}}}' | php artisan boost:mcp 2>/dev/null
```

### Tailwind CSS

```bash
# Flexbox y Grid
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["flexbox grid responsive"]}}}' | php artisan boost:mcp 2>/dev/null

# Dark mode
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"search-docs","arguments":{"queries":["dark mode theme"]}}}' | php artisan boost:mcp 2>/dev/null
```

## Otros Tools de Laravel Boost

### Ver información de la aplicación

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"application-info","arguments":{}}}' | php artisan boost:mcp 2>/dev/null
```

### Consultar base de datos (read-only)

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"database-query","arguments":{"query":"SELECT * FROM users LIMIT 5"}}}' | php artisan boost:mcp 2>/dev/null
```

### Ver schema de la base de datos

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"database-schema","arguments":{}}}}' | php artisan boost:mcp 2>/dev/null
```

### Ejecutar código PHP con Tinker

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"tinker","arguments":{"code":"User::count()","timeout":30}}}' | php artisan boost:mcp 2>/dev/null
```

### Ver rutas de la aplicación

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"list-routes","arguments":{}}}}' | php artisan boost:mcp 2>/dev/null
```

### Ver último error

```bash
echo '{"jsonrpc":"2.0","id":1,"method":"tools/call","params":{"name":"last-error","arguments":{}}}' | php artisan boost:mcp 2>/dev/null
```

## Tips

1. **Usa múltiples queries** si no estás seguro de la terminología exacta
2. **Limita por paquete** cuando sepas qué documentación necesitas
3. **Incrementa token_limit** si los resultados están truncados:
    ```bash
    {"queries":["tu consulta"],"token_limit":10000}
    ```
4. **Combina con Context7** para documentación de paquetes no Laravel (shadcn/ui, etc.)
