<?php

namespace App\Http\Controllers;

use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    /**
     * Get unread notifications (JSON).
     */
    public function index(Request $request)
    {
        return $request->user()->unreadNotifications()->limit(10)->get();
    }

    /**
     * Mark a notification as read.
     */
    public function markAsRead(string $id): RedirectResponse
    {
        request()->user()->notifications()->where('id', $id)->first()?->markAsRead();

        return back();
    }

    /**
     * Mark all notifications as read.
     */
    public function markAllAsRead(): RedirectResponse
    {
        request()->user()->unreadNotifications->markAsRead();

        return back();
    }
}
