<?php

namespace App\Http\Requests\Admin;

use App\Concerns\ProfileValidationRules;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Spatie\Permission\Models\Role;

class UpdateUserRequest extends FormRequest
{
    use ProfileValidationRules;

    public function authorize(): bool
    {
        return $this->user()->hasRole('admin');
    }

    public function rules(): array
    {
        $userId = $this->route('user');

        return [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', Rule::unique('users', 'email')->ignore($userId)],
            'password' => ['nullable', 'string', 'min:8', 'confirmed'],
            'age' => ['nullable', 'integer', 'min:18', 'max:120'],
            'gender' => ['nullable', 'string', 'in:male,female,other,prefer_not_to_say'],
            'country' => ['nullable', 'string', 'max:100'],
            'entheogen_activity' => ['nullable', 'string', 'max:1000'],
            'role' => ['sometimes', 'string', Rule::in(Role::pluck('name')->toArray())],
        ];
    }

    public function messages(): array
    {
        return [
            'role.in' => 'El rol seleccionado no es válido.',
            'email.unique' => 'Este correo electrónico ya está en uso por otro usuario.',
        ];
    }
}
