<?php

namespace App\Http\Responses;

use Illuminate\Http\RedirectResponse;
use Laravel\Fortify\Contracts\LoginResponse as LoginResponseContract;

class LoginResponse implements LoginResponseContract
{
    /**
     * Create an HTTP response that represents the object.
     *
     * Redirect users based on their role after login:
     * - Admin → /admin/dashboard
     * - Curator/User → / (home, authenticated)
     */
    public function toResponse($request): RedirectResponse
    {
        $user = $request->user();

        // Admin goes to admin dashboard
        if ($user->hasRole('admin')) {
            return redirect()->intended('/admin/dashboard');
        }

        // Curator and regular users go to home (landing page, but authenticated)
        return redirect()->intended('/');
    }
}
