<?php

namespace App\Notifications\Forum;

use App\Models\ForumPost;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class PostReply extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(public ForumPost $post)
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'post_reply',
            'post_id' => $this->post->id,
            'thread_id' => $this->post->thread_id,
            'forum_slug' => $this->post->thread->forum->slug,
            'thread_slug' => $this->post->thread->slug,
            'user_id' => $this->post->user_id,
            'user_name' => $this->post->user->name,
            'user_avatar' => $this->post->user->profile_photo_url,
            'message' => 'respondió a tu publicación en "'.$this->post->thread->title.'"',
        ];
    }
}
