<?php

namespace App\Notifications\Forum;

use App\Models\ForumPost;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class PostUpvoted extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(public ForumPost $post, public User $voter)
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'post_upvoted',
            'post_id' => $this->post->id,
            'thread_id' => $this->post->thread_id,
            'forum_slug' => $this->post->thread->forum->slug,
            'thread_slug' => $this->post->thread->slug,
            'user_id' => $this->voter->id,
            'user_name' => $this->voter->name,
            'user_avatar' => $this->voter->profile_photo_url,
            'message' => 'le gustó tu comentario en "'.$this->post->thread->title.'"',
        ];
    }
}
