<?php

namespace Database\Factories;

use App\Models\Forum;
use App\Models\ForumThread;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ForumThread>
 */
class ForumThreadFactory extends Factory
{
    protected $model = ForumThread::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $title = fake()->sentence();

        return [
            'forum_id' => Forum::factory(),
            'user_id' => User::factory(),
            'title' => $title,
            'slug' => Str::slug($title),
            'content' => fake()->paragraphs(3, true),
            'is_sticky' => false,
            'is_locked' => false,
        ];
    }

    /**
     * Indicate that the thread is sticky.
     */
    public function sticky(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_sticky' => true,
        ]);
    }

    /**
     * Indicate that the thread is locked.
     */
    public function locked(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_locked' => true,
        ]);
    }
}
