<?php

namespace Database\Seeders;

use App\Models\Forum;
use Illuminate\Database\Seeder;

class ForumsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $forums = [
            [
                'name' => 'Foro 1: Discusión Epistemológica',
                'slug' => 'discusion-epistemologica',
                'description' => 'Espacio para el diálogo epistemológico sobre saberes ancestrales y conocimiento científico moderno.',
                'order' => 1,
                'is_active' => true,
            ],
            [
                'name' => 'Foro 2: Incidencia Política',
                'slug' => 'incidencia-politica',
                'description' => 'Construyendo la posibilidad de la incidencia política relacionada con terapias enteógenas y regulaciones.',
                'order' => 2,
                'is_active' => true,
            ],
        ];

        foreach ($forums as $forumData) {
            Forum::create($forumData);
        }
    }
}
