<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * Roles based on Ser Ajayu documentation:
     * - Visitante (guest): View public content (handled by unauthenticated access)
     * - Usuario (user): Basic collaborator
     * - Curador (curator): Indigenous representatives, project collaborators
     * - Administrador (admin): Ser Ajayu staff, full management
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Define permissions by category
        $permissions = [
            // Document permissions
            'documents.view',
            'documents.upload',
            'documents.download',
            'documents.edit',
            'documents.delete',
            'documents.moderate',

            // Collaborative documents permissions
            'collaborative.view',
            'collaborative.comment',
            'collaborative.edit',
            'collaborative.create',
            'collaborative.moderate',

            // Forum permissions
            'forum.view',
            'forum.post',
            'forum.comment',
            'forum.vote',
            'forum.create-thread',
            'forum.create-room',
            'forum.moderate',
            'forum.delete',

            // Survey permissions
            'surveys.view',
            'surveys.respond',
            'surveys.create',
            'surveys.view-results',
            'surveys.delete',

            // Messages permissions
            'messages.send',
            'messages.receive',
            'messages.create-group',

            // Project permissions
            'projects.view',
            'projects.propose',
            'projects.manage',

            // Admin permissions
            'users.view',
            'users.manage',
            'roles.assign',
            'settings.manage',
            'analytics.view',
        ];

        // Create all permissions
        foreach ($permissions as $permission) {
            Permission::create(['name' => $permission]);
        }

        // Create roles and assign permissions

        // 1. Usuario (User) - Basic authenticated user
        $userRole = Role::create(['name' => 'user']);
        $userRole->givePermissionTo([
            'documents.view',
            'documents.upload',
            'documents.download',
            'collaborative.view',
            'collaborative.comment',
            'forum.view',
            'forum.post',
            'forum.comment',
            'forum.vote',
            'surveys.view',
            'surveys.respond',
            'messages.send',
            'messages.receive',
            'projects.view',
        ]);

        // 2. Curador (Curator) - Indigenous representatives, project collaborators
        $curatorRole = Role::create(['name' => 'curator']);
        $curatorRole->givePermissionTo([
            // All user permissions
            'documents.view',
            'documents.upload',
            'documents.download',
            'documents.edit',
            'collaborative.view',
            'collaborative.comment',
            'collaborative.edit',
            'collaborative.create',
            'forum.view',
            'forum.post',
            'forum.comment',
            'forum.vote',
            'forum.create-thread',
            'forum.create-room',
            'forum.moderate',
            'surveys.view',
            'surveys.respond',
            'surveys.view-results',
            'messages.send',
            'messages.receive',
            'messages.create-group',
            'projects.view',
            'projects.propose',
        ]);

        // 3. Administrador (Admin) - Full access
        $adminRole = Role::create(['name' => 'admin']);
        $adminRole->givePermissionTo(Permission::all());
    }
}
