<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * Create test users for each role: admin, curator, user.
     * All passwords are 'password' for testing.
     */
    public function run(): void
    {
        // Admin user
        $admin = User::create([
            'name' => 'Administrador Ser Ajayu',
            'email' => 'admin@serajayu.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'age' => 35,
            'gender' => 'prefer_not_to_say',
            'country' => 'Bolivia',
        ]);
        $admin->assignRole('admin');

        // Curator user
        $curator = User::create([
            'name' => 'Maria Quispe',
            'email' => 'curator@serajayu.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'age' => 42,
            'gender' => 'female',
            'country' => 'Perú',
            'entheogen_activity' => 'Representante de comunidad indígena amazónica. Guía de ceremonias tradicionales con ayahuasca.',
        ]);
        $curator->assignRole('curator');

        // Regular user
        $user = User::create([
            'name' => 'Carlos Mamani',
            'email' => 'user@serajayu.com',
            'password' => Hash::make('password'),
            'email_verified_at' => now(),
            'age' => 28,
            'gender' => 'male',
            'country' => 'Bolivia',
            'entheogen_activity' => 'Investigador de etnobotánica. Interés en plantas medicinales ancestrales.',
        ]);
        $user->assignRole('user');

        $this->command->info('✓ Created 3 test users:');
        $this->command->info('  - Admin: admin@serajayu.com (password)');
        $this->command->info('  - Curator: curator@serajayu.com (password)');
        $this->command->info('  - User: user@serajayu.com (password)');
    }
}
