# Prompt de Continuación para IA - Ser Ajayu

## Instrucciones Iniciales

Eres un asistente de desarrollo trabajando en el proyecto "Ser Ajayu", una plataforma web para la integración de saberes ancestrales andinos/amazónicos con investigación científica moderna sobre enteógenos y salud mental.

---

## PASOS OBLIGATORIOS ANTES DE EMPEZAR

### 1. Lee los archivos de configuración del proyecto

```
.agent/rules.md           → Reglas generales y convenciones
GEMINI.md                 → Guidelines de Laravel Boost (raíz del proyecto)
```

### 2. Lee los workflows disponibles

```
.agent/workflows/create-module.md        → Crear funcionalidad completa
.agent/workflows/create-component.md     → Crear componente React
.agent/workflows/create-form-request.md  → Crear Form Request con validaciones
.agent/workflows/create-action.md        → Crear Action para lógica de negocio
.agent/workflows/run-tests.md            → Ejecutar tests
.agent/workflows/search-docs.md          → Buscar documentación
```

### 3. Lee la documentación del proyecto

```
docs/IMPLEMENTATION.md    → Estado actual completo del proyecto
docs/information.md       → Ficha técnica y objetivos de la app
docs/Pantallas.png        → Wireframes de las pantallas
```

### 4. Usa Laravel Boost MCP

Laravel Boost es un MCP (Model Context Protocol) con herramientas especializadas para Laravel:

| Tool              | Uso                                            |
| ----------------- | ---------------------------------------------- |
| `search-docs`     | Buscar documentación de Laravel, Inertia, Pest |
| `database-schema` | Ver estructura de tablas de la base de datos   |
| `database-query`  | Ejecutar queries SQL read-only                 |
| `tinker`          | Ejecutar código PHP en contexto de la app      |
| `list-routes`     | Ver todas las rutas registradas                |
| `last-error`      | Ver el último error de la aplicación           |

### 5. Ejecuta comandos para entender el estado

```bash
# Ver rutas registradas
php artisan route:list

# Ver roles y permisos
php artisan permission:show

# Ver estructura de base de datos
php artisan db:show

# Iniciar desarrollo
composer run dev
```

---

## Stack Tecnológico

| Tecnología        | Versión | Uso                               |
| ----------------- | ------- | --------------------------------- |
| Laravel           | 12      | Backend                           |
| PHP               | 8.3     | Lenguaje servidor                 |
| React             | 19      | Frontend SPA                      |
| TypeScript        | -       | Tipado frontend                   |
| Inertia.js        | v2      | Puente Laravel-React sin API REST |
| TailwindCSS       | v4      | Estilos                           |
| shadcn/ui         | -       | Componentes UI base               |
| Spatie Permission | 6.24    | Roles y permisos                  |
| Wayfinder         | v0      | Generación rutas TypeScript       |
| Pest              | v4      | Testing                           |

---

## Lo Que Ya Está Implementado

### ✅ Autenticación Completa

- Registro con campos de perfil (nombre, email, password, avatar, edad, género, país, actividad)
- Login con email/password
- Login con Google OAuth
- Two-Factor Authentication
- Recuperación de contraseña
- Verificación de email
- Foto de perfil (subir, actualizar, eliminar)
- Redirección post-login por rol

### ✅ Sistema de Roles

- Roles: `user`, `curator`, `admin`
- Permisos granulares por módulo
- Middleware de roles en rutas
- Verificación en frontend vía `auth.roles`

### ✅ Foro de Discusión

- Listado de foros
- Threads (hilos) con sticky y lock
- Posts con respuestas anidadas
- Sistema de votaciones (upvote/downvote)
- Moderación (sticky, lock, delete)
- Acceso público para lectura

### ✅ Sistema de Notificaciones

- Notificaciones de respuestas
- Notificaciones de upvotes
- Dropdown con contador
- Marcar como leídas

### ✅ UI/UX Base

- Landing page animada
- Layouts público y autenticado
- Bottom tab navigator
- User dropdown con avatar
- Dark/Light mode
- Diseño responsive

---

## Lo Que Falta Implementar

### Alta Prioridad

1. **Repositorio de Documentos** - Subida/descarga, integración Google Drive
2. **Panel de Administración** - CRUD usuarios, gestión roles, estadísticas
3. **Encuestas Digitales** - Crear, responder, ver resultados

### Media Prioridad

4. **Documentos Colaborativos** - Editor en tiempo real
5. **Mensajería** - Chat privado y grupal

### Baja Prioridad

6. **Multilenguaje** - ES, EN, Quechua
7. **PWA/Mobile**
8. **Blockchain/NFTs**

---

## Estructura de Archivos Clave

### Backend

```
app/Http/Controllers/{Modulo}/{Nombre}Controller.php
app/Http/Requests/{Modulo}/{Accion}{Nombre}Request.php
app/Actions/Fortify/*.php
app/Models/*.php
routes/{web,user,curator,admin,settings}.php
```

### Frontend

```
resources/js/pages/{modulo}/{pagina}.tsx
resources/js/components/{tipo}/{componente}.tsx
resources/js/layouts/{nombre}-layout.tsx
resources/js/types/index.d.ts
```

---

## Reglas Importantes

1. **Explica antes de implementar** - Di qué vas a hacer y por qué
2. **Usa Form Requests** para validaciones, nunca inline
3. **Modifica migraciones directamente** en desarrollo, no crear `add_*`
4. **Corre tests** después de cambios: `php artisan test --compact`
5. **Formatea código** con `vendor/bin/pint`
6. **Regenera rutas TS** con `php artisan wayfinder:generate`
7. **Sigue convenciones existentes** - mira archivos hermanos

---

## Comandos Frecuentes

```bash
# Desarrollo
composer run dev

# Base de datos
php artisan migrate:fresh --seed

# Testing
php artisan test --compact
php artisan test --filter=NombreTest

# Utilidades
php artisan wayfinder:generate
vendor/bin/pint
php artisan route:list
```

---

## Notas del Desarrollador Anterior

1. Las imágenes de avatar usan URL relativa `/storage/...` para evitar problemas con APP_URL
2. Los roles se pasan como `auth.roles` (array de strings), no en el objeto user
3. El foro es público para lectura, requiere auth para participar
4. Hay validación de tamaño de archivo (2MB) en frontend para avatars
5. El storage symlink debe existir: `php artisan storage:link`

---

¡Buena suerte con el desarrollo! Si tienes dudas, revisa `docs/IMPLEMENTATION.md` primero.
