# Plan de Implementación - Ser Ajayu

## Resumen del Proyecto

**Ser Ajayu** es una plataforma digital (Hub) para facilitar la integración de saberes ancestrales andinos y amazónicos con evidencia científica moderna, promoviendo el desarrollo de terapias enteógenas responsables en salud mental.

### Objetivo General

Crear una plataforma digital que permita:

- Intercambio de información colaborativa, ética y transparente
- Respeto al conocimiento de comunidades indígenas
- Prevención de extractivismo cultural
- Evaluación crítica de contenidos

---

## Fase 0: Configuración Base ✅

- [x] Laravel 12 + Inertia + React + TypeScript
- [x] Autenticación con Fortify (2FA incluido)
- [x] Estructura de carpetas `.agent/`
- [x] Laravel Boost para documentación
- [ ] Definir paleta de colores (andina/amazónica)
- [ ] Crear layout principal con navegación bottom-tab

---

## Fase 1: Estructura y UI Base

### 1.1 Sistema de Diseño

**Prioridad: ALTA** | **Complejidad: Media**

| Tarea                                        | Estado |
| -------------------------------------------- | ------ |
| Definir variables CSS (colores, tipografía)  | ⬜     |
| Crear componentes base (Button, Card, Badge) | ⬜     |
| Implementar dark mode                        | ⬜     |
| Logo y iconografía andina/amazónica          | ⬜     |

**Paleta propuesta** (inspirada en naturaleza andina/amazónica):

- Primario: Verdes selva (#2D5016, #4A7C23)
- Secundario: Tierras/Ocres (#8B4513, #D2691E)
- Acento: Dorados (#DAA520, #FFD700)
- Neutros: Tierra (#3E3E3A, #706F6C)

### 1.2 Layout Principal

**Prioridad: ALTA** | **Complejidad: Media**

| Tarea                          | Estado |
| ------------------------------ | ------ |
| Bottom navigation bar (móvil)  | ⬜     |
| Sidebar (desktop)              | ⬜     |
| Header con selector de idioma  | ⬜     |
| Footer (MANTENER el existente) | ⬜     |

**Secciones de navegación:**

1. 🏠 Inicio
2. 📚 Repositorio (Documentos)
3. 💬 Foro
4. 📊 Encuestas
5. ✉️ Mensajes

---

## Fase 2: Sistema de Usuarios y Roles

### 2.1 Roles (RBAC)

**Prioridad: ALTA** | **Complejidad: Alta**

| Rol               | Permisos                                                                     |
| ----------------- | ---------------------------------------------------------------------------- |
| **Visitante**     | Ver repositorio, leer foros (sin comentar)                                   |
| **Usuario**       | Todo lo anterior + comentar, participar en encuestas/foros, subir documentos |
| **Curador**       | Todo lo anterior + editar documentos, moderar foros, proponer acciones       |
| **Administrador** | Gestión total, crear encuestas, asignar roles                                |

| Tarea                                  | Estado |
| -------------------------------------- | ------ |
| Migración para roles y permisos        | ⬜     |
| Modelo Role y Permission               | ⬜     |
| Middleware de autorización             | ⬜     |
| Políticas (Policies) para cada recurso | ⬜     |

### 2.2 Registro y Perfil

**Prioridad: ALTA** | **Complejidad: Media**

**Datos de registro:**

- Nombre
- Email
- Edad
- Sexo
- País de residencia
- Actividad laboral
- Actividad con enteógenos (opcional)
- Confirmación de mayoría de edad ✓

| Tarea                            | Estado |
| -------------------------------- | ------ |
| Formulario de registro extendido | ⬜     |
| Página de perfil de usuario      | ⬜     |
| Verificación de mayoría de edad  | ⬜     |
| Login social (Google/Microsoft)  | ⬜     |

---

## Fase 3: Repositorio de Documentos

### 3.1 Biblioteca Virtual

**Prioridad: ALTA** | **Complejidad: Alta**

**Funcionalidades:**

- Upload/download/view de archivos (PDFs, imágenes, audio, videos)
- Filtros por tema (etnofarmacología, protocolos, prácticas ancestrales)
- Búsqueda avanzada con palabras clave
- Almacenamiento: Servidor + Google Drive

**Áreas/Categorías:**

- Etnobotánica
- Psicología
- Antropología
- Protocolos de salud mental
- Prácticas ancestrales

| Tarea                                   | Estado |
| --------------------------------------- | ------ |
| Modelo Document con categorías          | ⬜     |
| Upload de archivos (S3/local)           | ⬜     |
| Integración con Google Drive            | ⬜     |
| Visor de documentos in-app              | ⬜     |
| Sistema de búsqueda (Meilisearch/Scout) | ⬜     |
| Filtros y ordenamiento                  | ⬜     |

### 3.2 Documentos Colaborativos

**Prioridad: MEDIA** | **Complejidad: Alta**

**Funcionalidades:**

- Edición colaborativa en tiempo real (estilo Google Docs)
- Moderación: Ediciones sujetas a revisión
- Alertas para contenidos no respaldados

| Tarea                           | Estado |
| ------------------------------- | ------ |
| Integración con Google Docs API | ⬜     |
| Sistema de versiones/historial  | ⬜     |
| Moderación de ediciones         | ⬜     |
| Notificaciones de cambios       | ⬜     |

---

## Fase 4: Foros de Discusión

### 4.1 Sistema de Foros

**Prioridad: MEDIA** | **Complejidad: Media**

**Foros propuestos:**

1. Construyendo procesos de incidencia política
2. Construyendo conocimiento colectivo
3. Construyendo nuevos proyectos

**Funcionalidades:**

- Hilos temáticos con respuestas
- Votaciones (up/down votes)
- Moderación automática (filtros de palabras) + manual
- Notificaciones push para respuestas

| Tarea                         | Estado |
| ----------------------------- | ------ |
| Modelo Forum, Thread, Comment | ⬜     |
| Página de listado de foros    | ⬜     |
| Página de hilo/discusión      | ⬜     |
| Sistema de votación           | ⬜     |
| Moderación automática         | ⬜     |
| Notificaciones                | ⬜     |

---

## Fase 5: Sistema de Encuestas

### 5.1 Encuestas Digitales

**Prioridad: MEDIA** | **Complejidad: Media**

**Funcionalidades:**

- Creación/distribución/análisis de encuestas
- Anonimato opcional
- Consentimiento informado obligatorio
- Visualización con gráficos básicos

| Tarea                             | Estado |
| --------------------------------- | ------ |
| Modelo Survey, Question, Response | ⬜     |
| Constructor de encuestas (admin)  | ⬜     |
| Formulario de respuesta           | ⬜     |
| Dashboard de resultados           | ⬜     |
| Exportación de datos              | ⬜     |

---

## Fase 6: Sistema de Mensajería

### 6.1 Mensajes Privados/Grupales

**Prioridad: BAJA** | **Complejidad: Alta**

**Funcionalidades:**

- Mensajería privada y grupal
- Cifrado end-to-end
- Notificaciones push
- Grupos temáticos o por rol

| Tarea                           | Estado |
| ------------------------------- | ------ |
| Modelo Message, Conversation    | ⬜     |
| UI de conversaciones            | ⬜     |
| Tiempo real (WebSockets/Reverb) | ⬜     |
| Grupos de chat                  | ⬜     |
| Cifrado E2E                     | ⬜     |

---

## Fase 7: Internacionalización

### 7.1 Soporte Multilingüe

**Prioridad: MEDIA** | **Complejidad: Media**

**Idiomas:**

1. Español (principal)
2. Inglés
3. Quechua/Aymara (futuro)

| Tarea                            | Estado |
| -------------------------------- | ------ |
| Configurar Laravel localization  | ⬜     |
| Archivos de traducción ES/EN     | ⬜     |
| Selector de idioma en header     | ⬜     |
| Traducciones de frontend (React) | ⬜     |

---

## Fase 8: Páginas Públicas

### 8.1 Landing Page

**Prioridad: ALTA** | **Complejidad: Media**

**Contenido:**

- Hero con logo y misión
- Botones: "Explorar Repositorio" y "Unirse a la Comunidad"
- Funcionalidades principales
- Proyectos destacados

| Tarea                       | Estado |
| --------------------------- | ------ |
| Rediseñar welcome.tsx       | ⬜     |
| Sección hero                | ⬜     |
| Sección funcionalidades     | ⬜     |
| Sección proyectos           | ⬜     |
| Footer (mantener el actual) | ⬜     |

### 8.2 Páginas Legales

**Prioridad: ALTA** | **Complejidad: Baja**

| Tarea                         | Estado |
| ----------------------------- | ------ |
| Política de privacidad        | ⬜     |
| Condiciones del servicio      | ⬜     |
| Reglamento de participación   | ⬜     |
| Reglamento de debates (foros) | ⬜     |

---

## Orden de Implementación: VISUAL FIRST 🎨

> **Estrategia:** Primero creamos toda la interfaz visual con datos mock,
> luego conectamos con el backend. Esto permite iterar rápido en el diseño.

---

### 🎨 PARTE 1: DISEÑO Y UI (Frontend)

#### Sprint 1: Sistema de Diseño Base (Semana 1)

1. ⬜ Paleta de colores andina/amazónica
2. ⬜ Variables CSS + tema dark mode
3. ⬜ Componentes base personalizados
4. ⬜ Logo e iconografía

#### Sprint 2: Layout y Navegación (Semana 1-2)

5. ⬜ Layout principal con bottom-tab (móvil)
6. ⬜ Sidebar para desktop
7. ⬜ Header con selector de idioma
8. ⬜ Footer (mantener el existente)

#### Sprint 3: Páginas Públicas (Semana 2)

9. ⬜ Landing page (hero, features, proyectos)
10. ⬜ Página "Sobre Nosotros"
11. ⬜ Páginas legales (privacidad, términos)

#### Sprint 4: Páginas de Usuario (Semana 2-3)

12. ⬜ Registro extendido (datos extra)
13. ⬜ Perfil de usuario
14. ⬜ Dashboard personal

#### Sprint 5: Repositorio UI (Semana 3)

15. ⬜ Listado de documentos con filtros
16. ⬜ Tarjetas de documento
17. ⬜ Visor de documento (modal)
18. ⬜ Página de categorías

#### Sprint 6: Foros UI (Semana 3-4)

19. ⬜ Listado de foros
20. ⬜ Vista de hilo/discusión
21. ⬜ Formulario de nuevo tema
22. ⬜ Sistema de votos (visual)

#### Sprint 7: Encuestas UI (Semana 4)

23. ⬜ Listado de encuestas
24. ⬜ Formulario de encuesta
25. ⬜ Resultados con gráficos

#### Sprint 8: Mensajes UI (Semana 4)

26. ⬜ Lista de conversaciones
27. ⬜ Chat UI
28. ⬜ Grupos

---

### ⚙️ PARTE 2: BACKEND (Después del visual)

#### Sprint 9: Base de Datos y Modelos

- Migraciones
- Modelos Eloquent
- Relaciones

#### Sprint 10: Roles y Autenticación

- Sistema RBAC con Spatie
- Políticas y permisos
- Registro extendido

#### Sprint 11: APIs y Conexiones

- Conectar UI con backend
- Validaciones (Form Requests)
- Upload de archivos

#### Sprint 12: Funcionalidades Avanzadas

- Búsqueda con Scout
- WebSockets para mensajes
- Internacionalización

---

## Notas Técnicas

### Paquetes a Instalar

```bash
# Roles y permisos
composer require spatie/laravel-permission

# Almacenamiento de archivos
composer require league/flysystem-aws-s3-v3

# Búsqueda
composer require laravel/scout
composer require meilisearch/meilisearch-php

# Websockets (mensajería)
composer require laravel/reverb

# Internacionalización frontend
npm install i18next react-i18next
```

### Migraciones Necesarias

1. `profiles` - Datos extendidos de usuario
2. `roles` y `permissions` - Sistema RBAC
3. `documents` - Repositorio
4. `categories` - Categorías de documentos
5. `forums` - Foros de discusión
6. `threads` - Hilos de foro
7. `comments` - Comentarios
8. `surveys` - Encuestas
9. `questions` - Preguntas de encuesta
10. `responses` - Respuestas
11. `conversations` - Conversaciones
12. `messages` - Mensajes

---

## Próximo Paso

**Comenzar con:** Sistema de diseño + Layout principal

Esto nos dará:

1. Base visual consistente para todas las páginas
2. Navegación funcional (bottom-tab móvil + sidebar desktop)
3. Estructura para agregar las funcionalidades

¿Aprobamos este plan y comenzamos con el Sprint 1?
