# Ficha Técnica de la App Ser Ajayu

## 1. Información General

- **Nombre de la Aplicación:** App Ser Ajayu
- **Versión Inicial:** 1.0 (Prototipo)
- **Plataforma:** Idealmente móvil multiplataforma (iOS y Android)

---

## 2. Objetivos

### Objetivo General

Crear una plataforma digital para implementar el Hub Ser Ajayu, facilitando la integración de saberes ancestrales andinos y amazónicos con evidencia científica moderna para promover el desarrollo de terapias enteógenas responsables en salud mental.

La app canaliza intercambios de información de manera colaborativa, ética y transparente, incluyendo tecnología blockchain, enfatizando el respeto al conocimiento de comunidades indígenas, prevención de extractivismo cultural y evaluación crítica de contenidos para evitar desinformación o promoción de actividades no reguladas.

La app permite un diálogo intercultural equilibrado, reconociendo beneficios terapéuticos (evidencia científica) y riesgos (prohibiciones históricas, impactos en salud). No fomentará prácticas ilegales; en su lugar, priorizará aspectos educativos, regulatorios y sostenibles.

### Objetivos Específicos

1. **Fomentar espacios de discusión crítica** sobre terapias enteógenas (Ayahuasca, San Pedro, Wilka u hongos psilocibios, entre otros), facilitadas para colaboración intercultural, orientación de procesos conjuntos de generación de conocimiento e incidencia política.

2. **Proporcionar herramientas y abrir canales** para la construcción colaborativa de documentos estratégicos, escritos y audiovisuales: análisis integrativos, protocolos, propuestas de regulación y de incidencia política para prácticas responsables.

3. **Generar información mediante encuestas electrónicas** para enriquecer espacios de discusión, orientar la formulación participativa de nuevos proyectos, procesos de investigación e incidencia política, entre otros.

4. **Implementar sistemas de certificación y trazabilidad** de sustancias y especies enteógenas para el reconocimiento de la diversidad biocultural andina - amazónica.

5. **Promover procesos colectivos regionales** de incidencia política, en función de evidencia y análisis colectivos, para lograr sistemas de regulación inclusivos y prácticas integrativas responsables.

---

## 3. Funcionalidades Principales

Implementar como pantallas y características modulares. Usar navegación intuitiva (bottom-tab o drawer menu) con secciones principales:

- Inicio
- Repositorio
- Documentos colaborativos
- Foro
- Encuestas
- Mensajes
- Perfil

**Soporte multilingüe:** español (principal), inglés, y quechua o aymara

### 3.1 Repositorio Virtual de Documentos

- Biblioteca searchable con upload/download/view de archivos (PDFs, imágenes, audio, videos)
- **Filtros:** Por tema (etnofarmacología, protocolos de salud mental, prácticas ancestrales), fecha, contribuidor
- **Almacenamiento:** Servidor y Google Drive
- Búsqueda avanzada con palabras clave

### 3.2 Construcción Colectiva de Documentos

- Edición colaborativa en tiempo real: Textos Google Docs, sonoros (grabación/edición básica de audio)
- **Moderación:** Ediciones sujetas a revisión por moderadores para mantener respeto cultural y evitar extractivismo
- **Crítica:** Enfatizar evaluación objetiva; incluir alertas para contenidos no respaldados por evidencia científica o ancestral

### 3.3 Foro de Intercambio de Percepciones

- Foro interactivo con hilos temáticos, respuestas, votaciones (up/down votes)
- **Temas:**
    1. Discusión epistemológica
    2. Incidencia política
- **Moderación:** Automática (filtros de palabras) + manual por moderadores para diálogos críticos y objetivos. Evitar promoción de actividades ilegales
- **Notificaciones:** Push para respuestas

### 3.4 Relevamiento de Información a Través de Encuestas Digitales

- Creación/distribución/análisis de encuestas (ej. experiencias terapéuticas, opiniones regulatorias)
- **Opciones:** Anonimato, consentimiento informado (obligatorio)
- **Análisis:** Gráficos básicos

### 3.5 Envío de Mensajes

- Mensajería privada/grupal con notificaciones push
- **Cifrado:** End-to-end para privacidad en temas sensibles (etnofarmacología, salud mental)
- **Grupos:** Temáticos o por rol

---

## 4. Pantallas y Contenido

La estructura de la app se define en función de los objetivos específicos en las siguientes pantallas:

| Pantalla                    | Descripción                                           |
| --------------------------- | ----------------------------------------------------- |
| 1. Ingreso                  | Login con email/contraseña o Google/Microsoft         |
| 2. Menú                     | Acceso a artículos del Blog, áreas funcionales        |
| 3. Foros                    | Discusión política, conocimiento colectivo, proyectos |
| 4. Documentos colaborativos | Protocolos, herramientas políticas, proyectos         |
| 5. Repositorio documentos   | Etnobotánica, psicología, antropología                |
| 6. Encuestas                | Valoraciones, bienestar psicológico                   |
| 7. Proyectos                | Sonoro, Hub de conocimiento, Video                    |

### Documentos del Repositorio (Links de Drive)

1. **Las plantas de los dioses** - Evans, Hofmann, Rätsch
    - https://drive.google.com/file/d/1ATRX0NbQBX6_6Cs7Fnf8jJyO-pSGfvO9/view

2. **El hombre que volvió a nacer** - Flores Apaza, Policarpio (2005)
    - https://drive.google.com/file/d/1-Eb_zdWmNuws59P_rcgC5wxonYo1fDgK/view

3. **Plantas medicinales La Paz - El Alto** - Maida, Moraes
    - https://docs.google.com/document/d/1Qi9Az3hlWIDAfQMBlYCuwHjp5NDu7ikb/edit

4. **Resignificación de la identidad mediante consumo de Yajé** - Marulanda Mejía
    - https://drive.google.com/file/d/1xofbuNjwKHzDEoZs_4-FUmb3wu5kU5Pt/view

5. **The Healing Journey** - Claudio Naranjo
    - https://drive.google.com/file/d/1bq92cuL0TIgrm4yWfeotHTrh9gyCYSBZ/view

6. **La psilocibina: perspectiva histórica y farmacológica** - Serrano Hurtado
    - https://drive.google.com/file/d/1vU9EDdNtLxHphKugCfl7ZBA6RBn__2-x/view

7. **Evidencias del impacto de ayahuasca ceremonial** - Timmer, Hilvert (2021)
    - https://drive.google.com/file/d/1WnsjYpU5kpY3nWnCAc_MpPg8Te_ifS70/view

---

## 5. Roles de Usuarios y Autenticación

### Roles (RBAC - Control de Acceso Basado en Roles)

| Rol               | Descripción                                          | Permisos                                                                                                                                                               |
| ----------------- | ---------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Visitante**     | Usuario no autenticado                               | Ver listado del repositorio, páginas públicas                                                                                                                          |
| **Usuario**       | Colaborador básico registrado                        | Ver, subir, descargar del repositorio. Comentar en documentos colaborativos. Participar en foros/encuestas/mensajes. Moderación requerida para publicaciones sensibles |
| **Curador**       | Representantes indígenas, colaboradores de proyectos | Todo lo de Usuario + Editar documentos, moderar foros, crear nuevas salas, proponer acciones/temas/proyectos                                                           |
| **Administrador** | Personal de Ser Ajayu                                | Gestión total: creación de encuestas, asignación de roles, análisis de datos, configuración de app                                                                     |

### Autenticación

- **Obligatoria** para usuarios, curadores y administradores
- **Opciones:** Email/contraseña o login social (Google, Facebook)

---

## 6. UI/UX y Diseño

- **Navegación:** Bottom navigation bar con iconos respetuosos (símbolos andinos/amazónicos sin apropiación)
- **Estilo Visual:** Colores inspirados en naturaleza andina/amazónica (verdes, tierras), tipografía legible
- **Mensajes educativos:** Pop-ups sobre actividades
- **Accesibilidad:** Soporte para lectores de pantalla, alto contraste

---

## 7. Proceso de Validación y Participación en Proyectos

El trabajo para alcanzar los objetivos y gestionar los proyectos estará acompañado por:

- Generación de **NFTs con tecnología Blockchain**
- Otras formas de reconocimiento que implicarán niveles de participación y acceso
- Acceso a información generada y al diseño conceptual y metodológico de los procesos
