import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Forum\ForumController::index
* @see app/Http/Controllers/Forum/ForumController.php:16
* @route '/foro'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/foro',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Forum\ForumController::index
* @see app/Http/Controllers/Forum/ForumController.php:16
* @route '/foro'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumController::index
* @see app/Http/Controllers/Forum/ForumController.php:16
* @route '/foro'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ForumController::index
* @see app/Http/Controllers/Forum/ForumController.php:16
* @route '/foro'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Forum\ForumController::index
* @see app/Http/Controllers/Forum/ForumController.php:16
* @route '/foro'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ForumController::index
* @see app/Http/Controllers/Forum/ForumController.php:16
* @route '/foro'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ForumController::index
* @see app/Http/Controllers/Forum/ForumController.php:16
* @route '/foro'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Forum\ForumController::show
* @see app/Http/Controllers/Forum/ForumController.php:55
* @route '/foro/{forum}'
*/
export const show = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/foro/{forum}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Forum\ForumController::show
* @see app/Http/Controllers/Forum/ForumController.php:55
* @route '/foro/{forum}'
*/
show.url = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { forum: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'slug' in args) {
        args = { forum: args.slug }
    }

    if (Array.isArray(args)) {
        args = {
            forum: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        forum: typeof args.forum === 'object'
        ? args.forum.slug
        : args.forum,
    }

    return show.definition.url
            .replace('{forum}', parsedArgs.forum.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumController::show
* @see app/Http/Controllers/Forum/ForumController.php:55
* @route '/foro/{forum}'
*/
show.get = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ForumController::show
* @see app/Http/Controllers/Forum/ForumController.php:55
* @route '/foro/{forum}'
*/
show.head = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Forum\ForumController::show
* @see app/Http/Controllers/Forum/ForumController.php:55
* @route '/foro/{forum}'
*/
const showForm = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ForumController::show
* @see app/Http/Controllers/Forum/ForumController.php:55
* @route '/foro/{forum}'
*/
showForm.get = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ForumController::show
* @see app/Http/Controllers/Forum/ForumController.php:55
* @route '/foro/{forum}'
*/
showForm.head = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

const ForumController = { index, show }

export default ForumController