import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteThread
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
export const deleteThread = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteThread.url(args, options),
    method: 'delete',
})

deleteThread.definition = {
    methods: ["delete"],
    url: '/foro/threads/{thread}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteThread
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
deleteThread.url = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { thread: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: typeof args.thread === 'object'
        ? args.thread.id
        : args.thread,
    }

    return deleteThread.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteThread
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
deleteThread.delete = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteThread.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteThread
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
const deleteThreadForm = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteThread.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteThread
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
deleteThreadForm.delete = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteThread.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

deleteThread.form = deleteThreadForm

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deletePost
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
export const deletePost = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deletePost.url(args, options),
    method: 'delete',
})

deletePost.definition = {
    methods: ["delete"],
    url: '/foro/posts/{post}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deletePost
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
deletePost.url = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { post: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { post: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            post: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        post: typeof args.post === 'object'
        ? args.post.id
        : args.post,
    }

    return deletePost.definition.url
            .replace('{post}', parsedArgs.post.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deletePost
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
deletePost.delete = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deletePost.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deletePost
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
const deletePostForm = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deletePost.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deletePost
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
deletePostForm.delete = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deletePost.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

deletePost.form = deletePostForm

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleSticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
export const toggleSticky = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: toggleSticky.url(args, options),
    method: 'post',
})

toggleSticky.definition = {
    methods: ["post"],
    url: '/foro/threads/{thread}/sticky',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleSticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
toggleSticky.url = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { thread: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: typeof args.thread === 'object'
        ? args.thread.id
        : args.thread,
    }

    return toggleSticky.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleSticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
toggleSticky.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: toggleSticky.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleSticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
const toggleStickyForm = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: toggleSticky.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleSticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
toggleStickyForm.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: toggleSticky.url(args, options),
    method: 'post',
})

toggleSticky.form = toggleStickyForm

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleLock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
export const toggleLock = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: toggleLock.url(args, options),
    method: 'post',
})

toggleLock.definition = {
    methods: ["post"],
    url: '/foro/threads/{thread}/lock',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleLock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
toggleLock.url = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { thread: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: typeof args.thread === 'object'
        ? args.thread.id
        : args.thread,
    }

    return toggleLock.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleLock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
toggleLock.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: toggleLock.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleLock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
const toggleLockForm = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: toggleLock.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::toggleLock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
toggleLockForm.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: toggleLock.url(args, options),
    method: 'post',
})

toggleLock.form = toggleLockForm

const ForumModerationController = { deleteThread, deletePost, toggleSticky, toggleLock }

export default ForumModerationController