import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../../wayfinder'
/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
export const show = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/foro/{forum}/{thread}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
show.url = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            forum: args[0],
            thread: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        forum: typeof args.forum === 'object'
        ? args.forum.slug
        : args.forum,
        thread: typeof args.thread === 'object'
        ? args.thread.slug
        : args.thread,
    }

    return show.definition.url
            .replace('{forum}', parsedArgs.forum.toString())
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
show.get = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
show.head = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
const showForm = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
showForm.get = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
showForm.head = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
export const store = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/foro/{forum}/threads',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
store.url = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { forum: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'slug' in args) {
        args = { forum: args.slug }
    }

    if (Array.isArray(args)) {
        args = {
            forum: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        forum: typeof args.forum === 'object'
        ? args.forum.slug
        : args.forum,
    }

    return store.definition.url
            .replace('{forum}', parsedArgs.forum.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
store.post = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
const storeForm = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
storeForm.post = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

const ThreadController = { show, store }

export default ThreadController