import { Badge } from '@/components/ui/badge';
import { Shield, User, Users } from 'lucide-react';
import { cn } from '@/lib/utils';

interface UserRoleBadgeProps {
    role: string;
    showIcon?: boolean;
}

const roleConfig = {
    admin: {
        label: 'Admin',
        icon: Shield,
        className: 'bg-forest/10 text-forest border-forest/30 hover:bg-forest/20',
    },
    curator: {
        label: 'Curador',
        icon: Users,
        className: 'bg-terracotta/10 text-terracotta border-terracotta/30 hover:bg-terracotta/20',
    },
    user: {
        label: 'Usuario',
        icon: User,
        className: 'bg-slate-100 text-slate-700 border-slate-300 hover:bg-slate-200',
    },
};

export function UserRoleBadge({ role, showIcon = true }: UserRoleBadgeProps) {
    const config = roleConfig[role as keyof typeof roleConfig] || roleConfig.user;
    const Icon = config.icon;

    return (
        <Badge variant="outline" className={cn('font-medium', config.className)}>
            {showIcon && <Icon className="mr-1 h-3 w-3" />}
            {config.label}
        </Badge>
    );
}
