import { Head, Link } from '@inertiajs/react';
import { motion } from 'framer-motion';
import { Mail, ChevronRight, Lock } from 'lucide-react';
import PublicLayout from '@/layouts/public-layout';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';

export default function MensajesIndex() {
    return (
        <PublicLayout>
            <Head title="Mensajes - Ser Ajayu" />

            <section className="relative py-16 lg:py-24 overflow-hidden">
                <div className="absolute inset-0 -z-10">
                    <div className="absolute top-0 left-1/4 h-64 w-64 rounded-full bg-terracotta/10 blur-[100px]" />
                </div>

                <div className="container mx-auto px-4">
                    <motion.div
                        initial={{ opacity: 0, y: 20 }}
                        animate={{ opacity: 1, y: 0 }}
                        transition={{ duration: 0.6 }}
                        className="max-w-3xl"
                    >
                        <nav className="flex items-center gap-2 text-sm text-muted-foreground mb-6">
                            <Link href="/" className="hover:text-foreground transition-colors">Inicio</Link>
                            <ChevronRight className="h-4 w-4" />
                            <span className="text-foreground">Mensajes</span>
                        </nav>

                        <div className="flex items-center gap-4 mb-4">
                            <div className="p-3 rounded-2xl bg-terracotta/10">
                                <Mail className="h-8 w-8 text-terracotta" />
                            </div>
                            <div>
                                <h1 className="text-3xl lg:text-4xl font-bold text-foreground">
                                    Mensajería
                                </h1>
                            </div>
                        </div>
                        <p className="text-lg text-muted-foreground mt-4 leading-relaxed">
                            Mensajería privada y grupal con cifrado end-to-end para temas sensibles.
                        </p>
                    </motion.div>

                    <motion.div
                        initial={{ opacity: 0, y: 20 }}
                        animate={{ opacity: 1, y: 0 }}
                        transition={{ delay: 0.3, duration: 0.6 }}
                        className="mt-16 text-center py-16 border border-dashed border-border rounded-2xl bg-muted/30"
                    >
                        <Lock className="h-16 w-16 text-terracotta mx-auto mb-4" />
                        <Badge className="bg-terracotta/20 text-terracotta border-terracotta/30 mb-4">
                            Requiere autenticación
                        </Badge>
                        <h3 className="text-xl font-semibold text-foreground mb-2">
                            Inicia sesión para acceder
                        </h3>
                        <p className="text-muted-foreground max-w-md mx-auto mb-6">
                            La mensajería está disponible solo para usuarios registrados. 
                            Inicia sesión o crea una cuenta para comunicarte con otros miembros.
                        </p>
                        <div className="flex items-center justify-center gap-4">
                            <Link href="/login">
                                <Button variant="outline">Iniciar sesión</Button>
                            </Link>
                            <Link href="/register">
                                <Button className="bg-forest hover:bg-forest-light">Registrarse</Button>
                            </Link>
                        </div>
                    </motion.div>
                </div>
            </section>
        </PublicLayout>
    );
}
