import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\Admin\ForumManagementController::index
* @see app/Http/Controllers/Admin/ForumManagementController.php:17
* @route '/admin/forums'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/admin/forums',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::index
* @see app/Http/Controllers/Admin/ForumManagementController.php:17
* @route '/admin/forums'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::index
* @see app/Http/Controllers/Admin/ForumManagementController.php:17
* @route '/admin/forums'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::index
* @see app/Http/Controllers/Admin/ForumManagementController.php:17
* @route '/admin/forums'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::index
* @see app/Http/Controllers/Admin/ForumManagementController.php:17
* @route '/admin/forums'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::index
* @see app/Http/Controllers/Admin/ForumManagementController.php:17
* @route '/admin/forums'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::index
* @see app/Http/Controllers/Admin/ForumManagementController.php:17
* @route '/admin/forums'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::store
* @see app/Http/Controllers/Admin/ForumManagementController.php:49
* @route '/admin/forums'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/admin/forums',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::store
* @see app/Http/Controllers/Admin/ForumManagementController.php:49
* @route '/admin/forums'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::store
* @see app/Http/Controllers/Admin/ForumManagementController.php:49
* @route '/admin/forums'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::store
* @see app/Http/Controllers/Admin/ForumManagementController.php:49
* @route '/admin/forums'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::store
* @see app/Http/Controllers/Admin/ForumManagementController.php:49
* @route '/admin/forums'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::update
* @see app/Http/Controllers/Admin/ForumManagementController.php:68
* @route '/admin/forums/{forum}'
*/
export const update = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/admin/forums/{forum}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::update
* @see app/Http/Controllers/Admin/ForumManagementController.php:68
* @route '/admin/forums/{forum}'
*/
update.url = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { forum: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { forum: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            forum: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        forum: typeof args.forum === 'object'
        ? args.forum.id
        : args.forum,
    }

    return update.definition.url
            .replace('{forum}', parsedArgs.forum.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::update
* @see app/Http/Controllers/Admin/ForumManagementController.php:68
* @route '/admin/forums/{forum}'
*/
update.put = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::update
* @see app/Http/Controllers/Admin/ForumManagementController.php:68
* @route '/admin/forums/{forum}'
*/
const updateForm = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::update
* @see app/Http/Controllers/Admin/ForumManagementController.php:68
* @route '/admin/forums/{forum}'
*/
updateForm.put = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::destroy
* @see app/Http/Controllers/Admin/ForumManagementController.php:87
* @route '/admin/forums/{forum}'
*/
export const destroy = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/admin/forums/{forum}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::destroy
* @see app/Http/Controllers/Admin/ForumManagementController.php:87
* @route '/admin/forums/{forum}'
*/
destroy.url = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { forum: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { forum: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            forum: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        forum: typeof args.forum === 'object'
        ? args.forum.id
        : args.forum,
    }

    return destroy.definition.url
            .replace('{forum}', parsedArgs.forum.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::destroy
* @see app/Http/Controllers/Admin/ForumManagementController.php:87
* @route '/admin/forums/{forum}'
*/
destroy.delete = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::destroy
* @see app/Http/Controllers/Admin/ForumManagementController.php:87
* @route '/admin/forums/{forum}'
*/
const destroyForm = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::destroy
* @see app/Http/Controllers/Admin/ForumManagementController.php:87
* @route '/admin/forums/{forum}'
*/
destroyForm.delete = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::threads
* @see app/Http/Controllers/Admin/ForumManagementController.php:104
* @route '/admin/forums/{forum}/threads'
*/
export const threads = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: threads.url(args, options),
    method: 'get',
})

threads.definition = {
    methods: ["get","head"],
    url: '/admin/forums/{forum}/threads',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::threads
* @see app/Http/Controllers/Admin/ForumManagementController.php:104
* @route '/admin/forums/{forum}/threads'
*/
threads.url = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { forum: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { forum: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            forum: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        forum: typeof args.forum === 'object'
        ? args.forum.id
        : args.forum,
    }

    return threads.definition.url
            .replace('{forum}', parsedArgs.forum.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::threads
* @see app/Http/Controllers/Admin/ForumManagementController.php:104
* @route '/admin/forums/{forum}/threads'
*/
threads.get = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: threads.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::threads
* @see app/Http/Controllers/Admin/ForumManagementController.php:104
* @route '/admin/forums/{forum}/threads'
*/
threads.head = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: threads.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::threads
* @see app/Http/Controllers/Admin/ForumManagementController.php:104
* @route '/admin/forums/{forum}/threads'
*/
const threadsForm = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: threads.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::threads
* @see app/Http/Controllers/Admin/ForumManagementController.php:104
* @route '/admin/forums/{forum}/threads'
*/
threadsForm.get = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: threads.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::threads
* @see app/Http/Controllers/Admin/ForumManagementController.php:104
* @route '/admin/forums/{forum}/threads'
*/
threadsForm.head = (args: { forum: number | { id: number } } | [forum: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: threads.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

threads.form = threadsForm

const forums = {
    index: Object.assign(index, index),
    store: Object.assign(store, store),
    update: Object.assign(update, update),
    destroy: Object.assign(destroy, destroy),
    threads: Object.assign(threads, threads),
}

export default forums