import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleSticky
* @see app/Http/Controllers/Admin/ForumManagementController.php:123
* @route '/admin/threads/{thread}/toggle-sticky'
*/
export const toggleSticky = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: toggleSticky.url(args, options),
    method: 'post',
})

toggleSticky.definition = {
    methods: ["post"],
    url: '/admin/threads/{thread}/toggle-sticky',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleSticky
* @see app/Http/Controllers/Admin/ForumManagementController.php:123
* @route '/admin/threads/{thread}/toggle-sticky'
*/
toggleSticky.url = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: args.thread,
    }

    return toggleSticky.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleSticky
* @see app/Http/Controllers/Admin/ForumManagementController.php:123
* @route '/admin/threads/{thread}/toggle-sticky'
*/
toggleSticky.post = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: toggleSticky.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleSticky
* @see app/Http/Controllers/Admin/ForumManagementController.php:123
* @route '/admin/threads/{thread}/toggle-sticky'
*/
const toggleStickyForm = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: toggleSticky.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleSticky
* @see app/Http/Controllers/Admin/ForumManagementController.php:123
* @route '/admin/threads/{thread}/toggle-sticky'
*/
toggleStickyForm.post = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: toggleSticky.url(args, options),
    method: 'post',
})

toggleSticky.form = toggleStickyForm

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleLock
* @see app/Http/Controllers/Admin/ForumManagementController.php:134
* @route '/admin/threads/{thread}/toggle-lock'
*/
export const toggleLock = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: toggleLock.url(args, options),
    method: 'post',
})

toggleLock.definition = {
    methods: ["post"],
    url: '/admin/threads/{thread}/toggle-lock',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleLock
* @see app/Http/Controllers/Admin/ForumManagementController.php:134
* @route '/admin/threads/{thread}/toggle-lock'
*/
toggleLock.url = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: args.thread,
    }

    return toggleLock.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleLock
* @see app/Http/Controllers/Admin/ForumManagementController.php:134
* @route '/admin/threads/{thread}/toggle-lock'
*/
toggleLock.post = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: toggleLock.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleLock
* @see app/Http/Controllers/Admin/ForumManagementController.php:134
* @route '/admin/threads/{thread}/toggle-lock'
*/
const toggleLockForm = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: toggleLock.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Admin\ForumManagementController::toggleLock
* @see app/Http/Controllers/Admin/ForumManagementController.php:134
* @route '/admin/threads/{thread}/toggle-lock'
*/
toggleLockForm.post = (args: { thread: string | number } | [thread: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: toggleLock.url(args, options),
    method: 'post',
})

toggleLock.form = toggleLockForm

const threads = {
    toggleSticky: Object.assign(toggleSticky, toggleSticky),
    toggleLock: Object.assign(toggleLock, toggleLock),
}

export default threads