import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\Forum\PostController::store
* @see app/Http/Controllers/Forum/PostController.php:19
* @route '/foro/threads/{thread}/posts'
*/
export const store = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/foro/threads/{thread}/posts',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Forum\PostController::store
* @see app/Http/Controllers/Forum/PostController.php:19
* @route '/foro/threads/{thread}/posts'
*/
store.url = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { thread: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: typeof args.thread === 'object'
        ? args.thread.id
        : args.thread,
    }

    return store.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\PostController::store
* @see app/Http/Controllers/Forum/PostController.php:19
* @route '/foro/threads/{thread}/posts'
*/
store.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\PostController::store
* @see app/Http/Controllers/Forum/PostController.php:19
* @route '/foro/threads/{thread}/posts'
*/
const storeForm = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\PostController::store
* @see app/Http/Controllers/Forum/PostController.php:19
* @route '/foro/threads/{thread}/posts'
*/
storeForm.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Forum\PostController::vote
* @see app/Http/Controllers/Forum/PostController.php:45
* @route '/foro/posts/{post}/vote'
*/
export const vote = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: vote.url(args, options),
    method: 'post',
})

vote.definition = {
    methods: ["post"],
    url: '/foro/posts/{post}/vote',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Forum\PostController::vote
* @see app/Http/Controllers/Forum/PostController.php:45
* @route '/foro/posts/{post}/vote'
*/
vote.url = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { post: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { post: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            post: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        post: typeof args.post === 'object'
        ? args.post.id
        : args.post,
    }

    return vote.definition.url
            .replace('{post}', parsedArgs.post.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\PostController::vote
* @see app/Http/Controllers/Forum/PostController.php:45
* @route '/foro/posts/{post}/vote'
*/
vote.post = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: vote.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\PostController::vote
* @see app/Http/Controllers/Forum/PostController.php:45
* @route '/foro/posts/{post}/vote'
*/
const voteForm = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: vote.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\PostController::vote
* @see app/Http/Controllers/Forum/PostController.php:45
* @route '/foro/posts/{post}/vote'
*/
voteForm.post = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: vote.url(args, options),
    method: 'post',
})

vote.form = voteForm

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
export const deleteMethod = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteMethod.url(args, options),
    method: 'delete',
})

deleteMethod.definition = {
    methods: ["delete"],
    url: '/foro/posts/{post}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
deleteMethod.url = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { post: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { post: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            post: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        post: typeof args.post === 'object'
        ? args.post.id
        : args.post,
    }

    return deleteMethod.definition.url
            .replace('{post}', parsedArgs.post.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
deleteMethod.delete = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteMethod.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
const deleteMethodForm = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteMethod.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:33
* @route '/foro/posts/{post}'
*/
deleteMethodForm.delete = (args: { post: number | { id: number } } | [post: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteMethod.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

deleteMethod.form = deleteMethodForm

const posts = {
    store: Object.assign(store, store),
    vote: Object.assign(vote, vote),
    delete: Object.assign(deleteMethod, deleteMethod),
}

export default posts