import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
export const show = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/foro/{forum}/{thread}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
show.url = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            forum: args[0],
            thread: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        forum: typeof args.forum === 'object'
        ? args.forum.slug
        : args.forum,
        thread: typeof args.thread === 'object'
        ? args.thread.slug
        : args.thread,
    }

    return show.definition.url
            .replace('{forum}', parsedArgs.forum.toString())
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
show.get = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
show.head = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
const showForm = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
showForm.get = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::show
* @see app/Http/Controllers/Forum/ThreadController.php:18
* @route '/foro/{forum}/{thread}'
*/
showForm.head = (args: { forum: string | { slug: string }, thread: string | { slug: string } } | [forum: string | { slug: string }, thread: string | { slug: string } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

const thread = {
    show: Object.assign(show, show),
}

export default thread