import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../wayfinder'
/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
export const store = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/foro/{forum}/threads',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
store.url = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { forum: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'slug' in args) {
        args = { forum: args.slug }
    }

    if (Array.isArray(args)) {
        args = {
            forum: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        forum: typeof args.forum === 'object'
        ? args.forum.slug
        : args.forum,
    }

    return store.definition.url
            .replace('{forum}', parsedArgs.forum.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
store.post = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
const storeForm = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ThreadController::store
* @see app/Http/Controllers/Forum/ThreadController.php:56
* @route '/foro/{forum}/threads'
*/
storeForm.post = (args: { forum: string | { slug: string } } | [forum: string | { slug: string } ] | string | { slug: string }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(args, options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
export const deleteMethod = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteMethod.url(args, options),
    method: 'delete',
})

deleteMethod.definition = {
    methods: ["delete"],
    url: '/foro/threads/{thread}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
deleteMethod.url = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { thread: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: typeof args.thread === 'object'
        ? args.thread.id
        : args.thread,
    }

    return deleteMethod.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
deleteMethod.delete = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: deleteMethod.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
const deleteMethodForm = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteMethod.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::deleteMethod
* @see app/Http/Controllers/Forum/ForumModerationController.php:16
* @route '/foro/threads/{thread}'
*/
deleteMethodForm.delete = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: deleteMethod.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

deleteMethod.form = deleteMethodForm

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::sticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
export const sticky = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: sticky.url(args, options),
    method: 'post',
})

sticky.definition = {
    methods: ["post"],
    url: '/foro/threads/{thread}/sticky',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::sticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
sticky.url = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { thread: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: typeof args.thread === 'object'
        ? args.thread.id
        : args.thread,
    }

    return sticky.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::sticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
sticky.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: sticky.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::sticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
const stickyForm = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: sticky.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::sticky
* @see app/Http/Controllers/Forum/ForumModerationController.php:48
* @route '/foro/threads/{thread}/sticky'
*/
stickyForm.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: sticky.url(args, options),
    method: 'post',
})

sticky.form = stickyForm

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::lock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
export const lock = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: lock.url(args, options),
    method: 'post',
})

lock.definition = {
    methods: ["post"],
    url: '/foro/threads/{thread}/lock',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::lock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
lock.url = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { thread: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { thread: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            thread: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        thread: typeof args.thread === 'object'
        ? args.thread.id
        : args.thread,
    }

    return lock.definition.url
            .replace('{thread}', parsedArgs.thread.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::lock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
lock.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: lock.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::lock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
const lockForm = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: lock.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\Forum\ForumModerationController::lock
* @see app/Http/Controllers/Forum/ForumModerationController.php:62
* @route '/foro/threads/{thread}/lock'
*/
lockForm.post = (args: { thread: number | { id: number } } | [thread: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: lock.url(args, options),
    method: 'post',
})

lock.form = lockForm

const threads = {
    store: Object.assign(store, store),
    delete: Object.assign(deleteMethod, deleteMethod),
    sticky: Object.assign(sticky, sticky),
    lock: Object.assign(lock, lock),
}

export default threads