import { InertiaLinkProps } from '@inertiajs/react';
import { LucideIcon } from 'lucide-react';

export interface Notification {
    id: string;
    type: string;
    data: {
        forum_slug: string;
        thread_slug: string;
        user_name: string;
        user_avatar?: string;
        message: string;
        [key: string]: unknown;
    };
    created_at: string;
    read_at: string | null;
}

export interface Auth {
    user: User;
    roles: string[];
    permissions: string[];
    notificationsCount: number;
    notifications: Notification[];
}

export interface BreadcrumbItem {
    title: string;
    href: string;
}

export interface NavGroup {
    title: string;
    items: NavItem[];
}

export interface NavItem {
    title: string;
    href: NonNullable<InertiaLinkProps['href']>;
    icon?: LucideIcon | null;
    isActive?: boolean;
}

export interface SharedData {
    name: string;
    auth: Auth;
    sidebarOpen: boolean;
    [key: string]: unknown;
}

export interface User {
    id: number;
    name: string;
    email: string;
    avatar?: string | null;
    profile_photo_url?: string | null;
    email_verified_at: string | null;
    two_factor_enabled?: boolean;
    // Profile fields
    age?: number | null;
    gender?: 'male' | 'female' | 'other' | 'prefer_not_to_say' | null;
    country?: string | null;
    entheogen_activity?: string | null;
    created_at: string;
    updated_at: string;
    [key: string]: unknown; // This allows for additional properties...
}

