<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Routes for administrators only. All routes here are prefixed with /admin
| and protected by the 'role:admin' middleware.
|
*/

Route::middleware(['auth', 'verified', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {
    // Dashboard
    Route::get('/dashboard', function () {
        return inertia('admin/dashboard', [
            'stats' => [
                'totalUsers' => \App\Models\User::count(),
                'totalDocuments' => 7,
                'totalSurveys' => 0,
                'pendingModerations' => 0,
            ],
        ]);
    })->name('dashboard');

    // User Management
    Route::resource('users', App\Http\Controllers\Admin\UserController::class)->except(['show', 'create', 'edit']);
    Route::post('users/{user}/role', [App\Http\Controllers\Admin\UserController::class, 'assignRole'])->name('users.assign-role');

    // Forum Management
    Route::get('forums', [App\Http\Controllers\Admin\ForumManagementController::class, 'index'])->name('forums.index');
    Route::post('forums', [App\Http\Controllers\Admin\ForumManagementController::class, 'store'])->name('forums.store');
    Route::put('forums/{forum}', [App\Http\Controllers\Admin\ForumManagementController::class, 'update'])->name('forums.update');
    Route::delete('forums/{forum}', [App\Http\Controllers\Admin\ForumManagementController::class, 'destroy'])->name('forums.destroy');

    // Thread Moderation
    Route::get('forums/{forum}/threads', [App\Http\Controllers\Admin\ForumManagementController::class, 'threads'])->name('forums.threads');
    Route::post('threads/{thread}/toggle-sticky', [App\Http\Controllers\Admin\ForumManagementController::class, 'toggleSticky'])->name('threads.toggle-sticky');
    Route::post('threads/{thread}/toggle-lock', [App\Http\Controllers\Admin\ForumManagementController::class, 'toggleLock'])->name('threads.toggle-lock');

    // Analytics
    // Route::get('analytics', [Admin\AnalyticsController::class, 'index'])->name('analytics');

    // Settings
    // Route::get('settings', [Admin\SettingsController::class, 'index'])->name('settings');
});
