<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Curator Routes
|--------------------------------------------------------------------------
|
| Routes for curators (indigenous representatives, project collaborators).
| All routes here are prefixed with /curator and protected by 'role:curator'.
|
| Note: Curators also have access to all user routes.
|
*/

Route::middleware(['auth', 'verified', 'role:curator'])->prefix('curator')->name('curator.')->group(function () {
    // Forum Moderation
    // Route::post('forum/moderate/{post}', [Curator\ForumModerationController::class, 'moderate'])->name('forum.moderate');
    // Route::delete('forum/posts/{post}', [Curator\ForumModerationController::class, 'delete'])->name('forum.delete');

    // Room Management
    // Route::post('rooms', [Curator\RoomController::class, 'store'])->name('rooms.store');

    // Document Editing
    // Route::put('documents/{document}', [Curator\DocumentController::class, 'update'])->name('documents.update');

    // Project Proposals
    // Route::post('projects/propose', [Curator\ProjectController::class, 'propose'])->name('projects.propose');
});
