<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| User Routes
|--------------------------------------------------------------------------
|
| Routes for authenticated users. All routes here are protected by 'auth'.
| These are basic user actions like uploading documents, posting in forums,
| responding to surveys, and managing their profile.
|
*/

// ============================================================================
// PUBLIC FORUM ROUTES (No authentication required - read-only)
// ============================================================================
Route::get('/foro', [App\Http\Controllers\Forum\ForumController::class, 'index'])->name('forum.index');
Route::get('/foro/{forum:slug}', [App\Http\Controllers\Forum\ForumController::class, 'show'])->name('forum.show');
Route::get('/foro/{forum:slug}/{thread:slug}', [App\Http\Controllers\Forum\ThreadController::class, 'show'])->name('forum.thread.show');

// ============================================================================
// AUTHENTICATED USER ROUTES
// ============================================================================
Route::middleware(['auth', 'verified'])->group(function () {
    // Dashboard / Profile
    Route::get('/dashboard', function () {
        return inertia('dashboard');
    })->name('dashboard');

    // Documents
    // Route::post('documents/upload', [User\DocumentController::class, 'upload'])->name('documents.upload');
    // Route::get('documents/{document}/download', [User\DocumentController::class, 'download'])->name('documents.download');

    // Forum Participation (requires auth)
    Route::post('/foro/{forum:slug}/threads', [App\Http\Controllers\Forum\ThreadController::class, 'store'])->name('forum.threads.store');
    Route::post('/foro/threads/{thread}/posts', [App\Http\Controllers\Forum\PostController::class, 'store'])->name('forum.posts.store');
    Route::post('/foro/posts/{post}/vote', [App\Http\Controllers\Forum\PostController::class, 'vote'])->name('forum.posts.vote');

    // Forum Moderation (requires auth + permissions)
    Route::delete('/foro/threads/{thread}', [App\Http\Controllers\Forum\ForumModerationController::class, 'deleteThread'])->name('forum.threads.delete');
    Route::delete('/foro/posts/{post}', [App\Http\Controllers\Forum\ForumModerationController::class, 'deletePost'])->name('forum.posts.delete');
    Route::post('/foro/threads/{thread}/sticky', [App\Http\Controllers\Forum\ForumModerationController::class, 'toggleSticky'])->name('forum.threads.sticky');
    Route::post('/foro/threads/{thread}/lock', [App\Http\Controllers\Forum\ForumModerationController::class, 'toggleLock'])->name('forum.threads.lock');

    // Surveys
    // Route::post('surveys/{survey}/respond', [User\SurveyController::class, 'respond'])->name('surveys.respond');

    // Messages
    // Route::get('messages', [User\MessageController::class, 'index'])->name('messages.index');
    // Route::post('messages', [User\MessageController::class, 'store'])->name('messages.store');

    // Notifications
    Route::get('/notifications', [App\Http\Controllers\NotificationController::class, 'index'])->name('notifications.index');
    Route::post('/notifications/{id}/read', [App\Http\Controllers\NotificationController::class, 'markAsRead'])->name('notifications.read');
    Route::post('/notifications/read-all', [App\Http\Controllers\NotificationController::class, 'markAllAsRead'])->name('notifications.read-all');
});
