<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use Laravel\Fortify\Features;

Route::get('/', function () {
    return Inertia::render('welcome', [
        'canRegister' => Features::enabled(Features::registration()),
    ]);
})->name('home');

// Public pages
Route::get('/documentos', function () {
    return Inertia::render('documents/index');
})->name('documents.index');

Route::get('/foro', function () {
    return Inertia::render('forum/index');
})->name('forum.index');

Route::get('/encuestas', function () {
    return Inertia::render('surveys/index');
})->name('surveys.index');

Route::get('/mensajes', function () {
    return Inertia::render('messages/index');
})->name('messages.index');

Route::get('/proyectos', function () {
    return Inertia::render('projects/index');
})->name('projects.index');

// OAuth Social Authentication Routes
Route::prefix('auth')->group(function () {
    Route::get('/{provider}/redirect', [App\Http\Controllers\Auth\SocialAuthController::class, 'redirect'])
        ->name('social.redirect');
    Route::get('/{provider}/callback', [App\Http\Controllers\Auth\SocialAuthController::class, 'callback'])
        ->name('social.callback');
});

require __DIR__.'/settings.php';
